﻿using System.Diagnostics;
using System.Net;
using System.Net.Sockets;
using System.Text;

try
{
    string IPADDRESS = "255.255.255.255";                               // Broadcast address , change it to your own
    string BCID = "IR-MODUL2-BROADCAST";
    int BCIDLEN = BCID.Length;
    int PORT = 55555;                                                   // UDP port for broadcasting
    if (args.Length > 0) IPADDRESS = args[0];                           // if a start paramter is given , use that as broadcast IP
    Console.WriteLine("Discover XI/CSV Ethernet devices (Broadcast IP "+ IPADDRESS+")...");
    UdpClient udpClient = new UdpClient();                              // create UDP client
    udpClient.Client.Bind(new IPEndPoint(IPAddress.Any, PORT));         // bind UDP client to broadcast port
    udpClient.Client.ReceiveTimeout = 50;                               // receive timeout 50ms
    var from = new IPEndPoint(0, 0);                                    // create network endpoint
    var data = Encoding.UTF8.GetBytes(BCID );                           // broadcast message
    udpClient.Send(data, data.Length, IPADDRESS, PORT);                 // send broadcast command to broadcast IP / port 
    byte[] rb ;                                                         // receive buffer
    UInt16 count = 0;                                                   // device count
    Stopwatch sw = new();                                               // stopwatch for max. search time
    sw.Start();                                                         // start stopwatch
    while (sw.ElapsedMilliseconds < 1000)                               // wait 1000ms for possible responses
    {
        try
        {
            rb = udpClient.Receive(ref from);                           // try to receive a UDP response
            if (rb.Length >= 39) {                                      // response must tbe greater than 38 bytes 
                if (Encoding.UTF8.GetString(rb).Contains(BCID))         // answer must start with "IR-MODUL2-BROADCAST"
                {
                    string macaddress   = string.Format("{0:X02}:{1:X02}:{2:X02}:{3:X02}:{4:X02}:{5:X02}", rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++]);
                    string staticip     = string.Format("{0}.{1}.{2}.{3}", rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++]);
                    string ipmode       = rb[BCIDLEN++] == 1 ? "DHCP" : "STATIC";
                    string netmask      = string.Format("{0}.{1}.{2}.{3}", rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++], rb[BCIDLEN++]);
                    int port_cfg        = rb[BCIDLEN++] * 256 + rb[BCIDLEN++];
                    int port_cmd        = rb[BCIDLEN++] * 256 + rb[BCIDLEN++];
                    int port_modbus     = rb[BCIDLEN++] * 256 + rb[BCIDLEN++];
                    Console.WriteLine((++count).ToString("Device : 0"));
                    Console.WriteLine("\t\tcurrent IP :\t" + from.Address.ToString());
                    Console.WriteLine("\t\tMAC address :\t" + macaddress);
                    Console.WriteLine("\t\tstatic IP :\t" + staticip);
                    Console.WriteLine("\t\tIP mode :\t" + ipmode);
                    Console.WriteLine("\t\tNetmask :\t" + netmask);
                    Console.WriteLine("\t\t" + port_cfg.ToString("PORT CFG :\t0"));
                    Console.WriteLine("\t\t" + port_cmd.ToString("PORT CMD :\t0"));
                    Console.WriteLine("\t\t" + port_modbus.ToString("PORT MODBUS :\t0"));
                }
            }
        }
        catch (Exception) {}
    }
    sw.Stop();
    udpClient.Close();
}
catch (Exception e)
{
    Console.WriteLine("Unexpected exception : {0}", e.ToString());
}


